/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.nbtedit.packets;

import com.mcf.davidee.nbtedit.NBTEdit;
import com.mcf.davidee.nbtedit.packets.AbstractPacket;
import com.mcf.davidee.nbtedit.packets.EntityNBTPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.logging.Level;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class EntityRequestPacket
extends AbstractPacket {
    private int entityID;

    public EntityRequestPacket() {
    }

    public EntityRequestPacket(int entityID) {
        this.entityID = entityID;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.entityID);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.entityID = buffer.readInt();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayerMP player) {
        Entity e = player.field_70170_p.func_73045_a(this.entityID);
        if (e instanceof EntityPlayer && e != player) {
            this.sendMessageToPlayer((EntityPlayer)player, "\u00a7cError - You may not use NBTEdit on other Players");
            NBTEdit.log(Level.WARNING, player.func_70005_c_() + " tried to use NBTEdit on another player, " + ((EntityPlayer)e).func_70005_c_());
        } else if (e != null) {
            NBTTagCompound tag = new NBTTagCompound();
            e.func_70109_d(tag);
            NBTEdit.DISPATCHER.sendTo(new EntityNBTPacket(this.entityID, tag), player);
        } else {
            this.sendMessageToPlayer((EntityPlayer)player, "\u00a7cError - Unknown EntityID #" + this.entityID);
        }
    }
}

