electron = require('electron')
var app=electron.app
BrowserWindow= electron.BrowserWindow

var path = require('path')
var url = require('url')
var fs = require('fs')
var isdev=false
win={}
var template = [
	{
		label: 'File',
		submenu: [
			{
				label: 'Open',
				click:function (menuItem, currentWindow){currentWindow.webContents.send("open")}
			},
			{
				label: 'Save',
				click:function (menuItem, currentWindow){currentWindow.webContents.send("save")},
				accelerator: 'CmdOrCtrl+S',
			},
			{
				role: 'close'
			},
		]
	},
	{
		label: 'Edit',
		submenu: [
			{
				role: 'undo'
			},
			{
				role: 'redo'
			},
			{
				type: 'separator'
			},
			{
				role: 'cut'
			},
			{
				role: 'copy'
			},
			{
				role: 'paste'
			},
			{
				role: 'pasteandmatchstyle'
			},
			{
				role: 'delete'
			},
			{
				role: 'selectall'
			}
		]
	},
	{
		label: 'View',
		submenu:(function(){var a= [
			{
				label: 'Reload',
				accelerator: 'CmdOrCtrl+R',
				click (item, focusedWindow) {
					if (focusedWindow) focusedWindow.reload()
				}
			},
			{
				label: 'Toggle Developer Tools',
				accelerator: process.platform === 'darwin' ? 'Alt+Command+I' : 'Ctrl+Shift+I',
				click (item, focusedWindow) {
					if (focusedWindow) focusedWindow.webContents.toggleDevTools()
				}
			},
			{
				type: 'separator'
			}]
			var b=[
			{
				role: 'resetzoom'
			},
			{
				role: 'zoomin'
			},
			{
				role: 'zoomout'
			},
			{
				type: 'separator'
			},
			{
				role: 'togglefullscreen'
			}
			]
			if(isdev){
				return a.concat(b)
			}else{
				return b
			}
			
		})()
		
	},
	{
		role: 'window',
		submenu: [
			{
				role: 'minimize'
			},
			{
				role: 'close'
			}
		]
	}/*,
	{
		role: 'help',
		submenu: [
			{
				label: 'Learn More',
				click () { require('electron').shell.openExternal('http://electron.atom.io') }
			}
		]
	}*/
]

if (process.platform === 'darwin') {
	name = app.getName()
	template.unshift({
		label: name,
		submenu: [
			{
				role: 'about'
			},
			{
				type: 'separator'
			},
			{
				role: 'services',
				submenu: []
			},
			{
				type: 'separator'
			},
			{
				role: 'hide'
			},
			{
				role: 'hideothers'
			},
			{
				role: 'unhide'
			},
			{
				type: 'separator'
			},
			{
				role: 'quit'
			}
		]
	})
	// Edit menu.
	template[1].submenu.push(
		{
			type: 'separator'
		},
		{
			label: 'Speech',
			submenu: [
				{
					role: 'startspeaking'
				},
				{
					role: 'stopspeaking'
				}
			]
		}
	)
	// Window menu.
	template[3].submenu = [
		{
			label: 'Close',
			accelerator: 'CmdOrCtrl+W',
			role: 'close'
		},
		{
			label: 'Minimize',
			accelerator: 'CmdOrCtrl+M',
			role: 'minimize'
		},
		{
			label: 'Zoom',
			role: 'zoom'
		},
		{
			type: 'separator'
		},
		{
			label: 'Bring All to Front',
			role: 'front'
		}
	]
}

var menu = electron.Menu.buildFromTemplate(template)



fs.stat("data",function(err){
	if(err){fs.mkdir("data",function(){})}
})


function createWindow () {
	electron.Menu.setApplicationMenu(menu)
	win = new BrowserWindow({width: 1000, height: 600})

	win.loadURL(url.format({
		pathname: path.join(__dirname, 'page.html'),
		protocol: 'file:',
		slashes: true
	}))
	//win.webContents.openDevTools()
	for(var x in win.webContents){
		//console.log(x,":",typeof win.webContents[x])
	}
	win.on('closed', function(){
		win = null
	})
}


app.on('ready', createWindow)


app.on('window-all-closed', function(){
	if (process.platform !== 'darwin') {
		app.quit()
	}
})

app.on('activate', function(){
	if (win === null) {
		createWindow()
	}
})
